program spkrtst5;
{this method is DOSBox-safe}

{
Test 1: Load data from a .wav file, play it through the speaker.
Nothing fancy.  Do it as safe as possible.
Test 2: Move playing into a procedure so it is cleaner to use. debug it.
Test 3: Massage data to fit the output rate.
Test 4: Determine fastest output rate with existing code
Test 5: Optimize. Last test locked up at div. 45.  This locks up at 43.
}

uses
  support,
  iff;

var
  wavData:IFFStream;
  wavHeader:IFFHeaderType;
  tmpChunk:IFFChunkType;
  sourcebuf,soundbuf:pointer;
  b:byte;
  pb:^byte;
  soundbufsize:word;

  PITdivisor:word;

procedure massagebuf(sndbuf:pointer;sndsize,divisor:word);
{
Massages 0-255 data to fit the target output rate.  For example, if
divisor is 64, then data should fit values 0-63.
}
type
  tbarray=array[0..255] of byte;
  pbarray=^tbarray;
var
  transtable:pbarray;
  b:byte;
begin
  new(transtable);
  for b:=0 to 255 do transtable^[b]:=trunc(b / (256 / divisor));
  asm
    push ds
    mov cx,sndsize
    les di,sndbuf
    lds bx,transtable
    cld
  @translate:
    mov al,es:[di]
    xlat
    stosb
    loop @translate
    pop ds
  end;
  dispose(transtable);
end;

procedure playbuf(sndbuf:pointer;sndsize,divisor:word);
var
  oldInt8:pointer;
  PIC0IMR:byte;
begin
  asm
    jmp     @initspeaker;           {skip past our int handler}

@int8Handler:
    lodsb                           {load next sample}
    out     42h,al                  {Tell CTC channel 2 to make a pulse}
    mov     al,dl                   {EOI command (dx=20h}
    out     dx,al                   {Send to primary PIC}
    iret                            {Return from interrupt}

@initSpeaker:
    mov     ax,3508h	              {Get interrupt vector for int 8}
    int     21h
    mov     WORD PTR OldInt8,bx     {Store offset}
    mov     WORD PTR OldInt8+2,es   {Store segment}

{Wait for all floppy drives to turn off.  There are more graceful ways to
do this, such as not locking up if motor never shuts off, but this will do
for now.}

    xor     ax,ax
    mov     es,ax                   {Address BIOS data area with ES}
@WaitMotors:
    test    BYTE PTR es:[43Fh],0Fh  {Any floppy drive motors active?}
    jnz     @WaitMotors             {If so, wait}


{Disable all interrupt sources on the primary (or only) PIC.  Keep the
original IMR contents, to be restored later.}

    cli
    in      al,21h                  {Read primary PIC IMR}
    DB      0EBh,000h               {JMP SHORT +2, short delay, almost never necessary :-/}
    mov     PIC0IMR,al              {Store it for later}
    mov     al,0FFh                 {Mask off _everything_}
    out     21h,al

{Set up Port B and CTC channel 2}

    in      al,61h                  {Read Port B}
    DB      0EBh,000h               {JMP SHORT +2, short delay}
    and     al,11111101b            {Speaker enable OFF}
    or      al,00000001b            {Timer 2 gate ON}
    out     61h,al                  {Write it back}
    DB      0EBh,000h               {JMP SHORT +2, short delay}
    mov     al,10010000b            {Channel 2, lobyte access, mode 0}
    out     43h,al                  {Set mode of channel 2 (no values yet)}
    sti			                        {Allow interrupts}

{Now grab int 8, the timer tick interrupt.  DOS should leave the PIC IMR alone.}

    push    ds
    mov     ax,SEG @int8Handler
    mov     ds,ax
		mov     dx,OFFSET @int8Handler  {Offset of new int 8 routine}
		mov     ax,2508h                {Set interrupt vector for int 8}
		int     21h
    pop     ds

{Reprogram CTC channel 0 with the new interrupt rate}

		cli			                        {Lock out interrupts again}
		mov     al,00110110b            {Channel 0, lobyte/hibyte, mode 3}
		out     43h,al                  {Write mode/command register}
    DB      0EBh,000h               {JMP SHORT +2, short delay}
		mov     al,BYTE PTR divisor     {Lobyte of new divisor}
		out     40h,al                  {Send it}
    DB      0EBh,000h               {JMP SHORT +2, short delay}
		mov     al,BYTE PTR divisor+1   {Hibyte of new divisor}
		out     40h,al                  {Send it}
    DB      0EBh,000h               {JMP SHORT +2, short delay}

{Enable the speaker}

    in      al,61h
    DB      0EBh,000h               {JMP SHORT +2, short delay}
    or      al,00000011b            {Timer 2 gate and speaker enable ON}
    out     61h,al
    DB      0EBh,000h               {JMP SHORT +2, short delay}

{Enable int 8 (IRQ0) in the PIC}

		mov     al,11111110b            {All masked except IRQ0}
		out     21h,al                  {Set primary PIC IMR}
    DB      0EBh,000h               {JMP SHORT +2, short delay}

{Point to buffer to play from}
    mov     cx,soundbufsize
    shr     cx,1
    shr     cx,1
    shr     cx,1
    shr     cx,1                    {to unroll loop a little}
    push    ds
    lds     si,soundbuf
    mov     dx,20h                  {load dx up with EOI command}

{Start playing.  There is enough CPU time left over to maintain a counter.}
		sti                             {enable interupts}
@playsamp:
    hlt                             {wait for interrupt handler to service it}
    hlt;hlt;hlt
    hlt;hlt;hlt;hlt
    hlt;hlt;hlt;hlt
    hlt;hlt;hlt;hlt
    loop    @playsamp

{Done playing.  Clean up time.  Restore regs, disable the speaker:}

    pop     ds

    pushf                           {Preserve interrupt flag}
    cli			                        {Lock out interrupts around this part}
    in      al,61h		              {Read Port B}
    DB      0EBh,000h               {JMP SHORT +2, short delay}
    and     al,11111100b	          {Disable Timer 2 and speaker}
    out     61h,al                  {Write it back}
    DB      0EBh,000h               {JMP SHORT +2, short delay}

{Disable all interrupt sources in the primary PIC}

    mov     al,0FFh                 {Mask all IRQ0-7}
    out     21h,al                  {Set PIC0 IMR}

{Restore normal operation of CTC channel 0}

    mov     al,00110110b            {Channel 0, lobyte/hibyte, mode 3}
    out     43h,al                  {Write mode/command word}
    DB      0EBh,000h               {JMP SHORT +2, short delay}
    xor     al,al
    out     40h,al                  {Write loword of reload value}
    DB      0EBh,000h               {JMP SHORT +2, short delay}
    out     40h,al                  {Write hiword of reload value}
    popf                            {Interrupts are still safe (PIC is blocked)}

{Restore original int 8 handler address}

    push    ds
    mov     dx,WORD PTR OldInt8     {Get offset}
    mov     ds,WORD PTR OldInt8+2   {Get segment}
    mov     ax,2508h	              {Set int 8 vector}
    int     21h
    pop     ds

{Restore original IMR}

    mov     al,PIC0IMR              {Get old IMR contents}
    out     21h,al                  {Restore IMR}

  end;
end;

begin
  if paramstr(1)='' then fatalerror(1,'No source filename present on command-line!');
  wavData.init(paramstr(1),IFFOpen,32768,@wavHeader); {Open mode, max. buffer cache, and fill Header1 with the results}
  if wavData.status <> IFF_noerror {if there was an error opening the file, bail out}
    then fatalerror(3,'Error opening IFF file');
  writeln('IFF File Type: "',wavData.HeaderChunk^.header,
          #34#13#10'Total Payload Size: ',wavData.HeaderChunk^.Totalsize,
          #34#13#10'IFF Content Type: ',wavData.HeaderChunk^.ContentType,'');
  for b:=0 to 7 do begin {loop over chunks until we find our data}
    wavData.SeekNextChunk; {seek to the next chunk and read chunk details in}
    if wavData.CurrentChunk^.name='data' then break;
  end;
  {force 64K only for now}
  if wavData.CurrentChunk^.size > maxbufsize
    then wavData.CurrentChunk^.size := maxbufsize;
  soundbufsize:=wavData.CurrentChunk^.size;
  getmem(sourcebuf,soundbufsize);
  {grab nearly full 64K for sound buffer so we can audibly detect overruns}
  getmem(soundbuf,maxbufsize);
  {fill sound buffer with noise so we can audibly detect overruns}
  move(ptr(0,0)^,soundbuf^,maxbufsize);
  {Load chunk payload into Buffer}
  wavData.GetChunkData(sourcebuf);
  if (wavData.status<>iff_noerror) then fatalerror(2,'Error loading chunk data');
  wavData.done;

  {load data into sound buffer, massaging as necessary}
  move(sourcebuf^,soundbuf^,soundbufsize);
  {check to see we have the right data}
  pb:=soundbuf;
  writeln;
  for b:=0 to 39 do begin
    write(hex(pb^)); inc(word(pb));
  end;

  for PITdivisor:=72 downto 72 do begin
    move(sourcebuf^,soundbuf^,soundbufsize);
    massagebuf(soundbuf,soundbufsize,PITdivisor);
    writeln('Attempting to play at a divisor of ',PITdivisor,' (',1193182 div PITdivisor,' Hz)');
    playbuf(soundbuf,soundbufsize,PITdivisor);
    if keypressed then break;
  end;
end.
